

#Computes the power of the Friedman-Rafsky test for the plots in Figure 2, 3, and 4. 


library(cluster)
library(vegan)
library(mnormt)

####################################################

#Computes the power of the Friedman-Rafsky test for the plot in Figure 2 (normal location problem in dimension d=10)

d=10
m=1000
n=500
iter=500
iterations=100

h=seq(0, 3, length.out=20)

power=vector(length=20)


rpnull=vector(length=iter)
rp=vector(length=iterations)

mu0=rep(0, d)
sigma0=diag(rep(1, d))

for(i in 1:iter)
{
  
  points1<-rmnorm(m, mu0, sigma0)
  points2<-rmnorm(n, mu0, sigma0)
  points<-rbind(points1,points2)
  x<-as.matrix(vegdist(points, binary=FALSE, method="euclidean"))
  child<-spantree(x)$kid
  edges<-t(rbind(c(2:(m+n)), child))
  
  rpnull[i]<-length(which(edges[1:(m-1),][,2]>m))+length(which(edges[m:(m+n-1),][,2]<=m))
  
}



for(j in 1:20)
{
	
	
delta1<-h[j]*rep(1, d)/sqrt(m+n)	
mu1=delta1

	


for(i in 1:iterations)
{
  
  points1<-rmnorm(m, mu0, sigma0)
  points2<-rmnorm(n, mu1, sigma0)
  points<-rbind(points1,points2)
  x<-as.matrix(vegdist(points, binary=FALSE, method="euclidean"))
  child<-spantree(x)$kid
  edges<-t(rbind(c(2:(m+n)), child))
  
  rp[i]<-length(which(edges[1:(m-1),][,2]>m))+length(which(edges[m:(m+n-1),][,2]<=m))
  
  
}

power[j]<-length(which(rp< quantile(rpnull, 0.05)))/iterations

}

write(as.vector(power), file="FRNormal.txt", ncolumns=1)

####################################################

#Computes the power of the Friedman-Rafsky test for the plot in Figure 3 (normal scale problem in dimension d=10)

d=10
m=1000
n=500
iter=500
iterations=100

h=seq(0, 3, length.out=20)

power=vector(length=20)


rpnull=vector(length=iter)
rp=vector(length=iterations)

mu0=rep(0, d)
sigma0=diag(rep(1, d))


for(i in 1:iter)
{
  
  points1<-rmnorm(m, mu0, sigma0)
  points2<-rmnorm(n, mu0, sigma0)
  points<-rbind(points1,points2)
  x<-as.matrix(vegdist(points, binary=FALSE, method="euclidean"))
  child<-spantree(x)$kid
  edges<-t(rbind(c(2:(m+n)), child))
  
  rpnull[i]<-length(which(edges[1:(m-1),][,2]>m))+length(which(edges[m:(m+n-1),][,2]<=m))
  
}

for(j in 1:20)
{
  

  delta1<-h[j]/(m+n)^(1/2)  
  sigma1=sigma0+delta1*diag(rep(1, d))
  
  
  for(i in 1:iterations)
  {
    
    points1<-rmnorm(m, mu0, sigma0)
    points2<-rmnorm(n, mu0, sigma1)
    points<-rbind(points1,points2)
    x<-as.matrix(vegdist(points, binary=FALSE, method="euclidean"))
    child<-spantree(x)$kid
    edges<-t(rbind(c(2:(m+n)), child))
    
    rp[i]<-length(which(edges[1:(m-1),][,2]>m))+length(which(edges[m:(m+n-1),][,2]<=m))
    
    
  }
  
  power[j]<-length(which(rp< quantile(rpnull, 0.05)))/iterations
  
}

write(as.vector(power), file="FRScale.txt", ncolumns=1)

####################################################

#Computes the power of the Friedman-Rafsky test for the plot in Figure 4 (lognormal location problem in dimension d=10)


d=10
m=1000
n=500
iter=500
iterations=100

h=seq(0, 3, length.out=20)

power=vector(length=20)


rpnull=vector(length=iter)
rp=vector(length=iterations)

mu0=rep(0, d) 
sigma0=diag(rep(1, d))

for(i in 1:iter)
{
  
  points1<-exp(rmnorm(m, mu0, sigma0))
  points2<-exp(rmnorm(n, mu0, sigma0))
  points<-rbind(points1,points2)
  x<-as.matrix(vegdist(points, binary=FALSE, method="euclidean"))
  child<-spantree(x)$kid
  edges<-t(rbind(c(2:(m+n)), child))
  
  rpnull[i]<-length(which(edges[1:(m-1),][,2]>m))+length(which(edges[m:(m+n-1),][,2]<=m))
  
}



for(j in 1:20)
{
  
  
  delta1<-h[j]*rep(1, d)/sqrt(m+n)	
  mu1=delta1 
  

  #Calculating the power of the Friedman-Rafsky Test in dimension d
  
  for(i in 1:iterations)
  {
    
    points1<-exp(rmnorm(m, mu0, sigma0))
    points2<-exp(rmnorm(n, mu1, sigma0))
    points<-rbind(points1,points2)
    x<-as.matrix(vegdist(points, binary=FALSE, method="euclidean"))
    child<-spantree(x)$kid
    edges<-t(rbind(c(2:(m+n)), child))
    
    rp[i]<-length(which(edges[1:(m-1),][,2]>m))+length(which(edges[m:(m+n-1),][,2]<=m))
    
    
  }
  
  power[j]<-length(which(rp< quantile(rpnull, 0.05)))/iterations
  
}

write(as.vector(power), file="FRLognormal.txt", ncolumns=1)

####################################################

